/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "../x86emu.h"

//global variables
//----------------
int pages=0;                //the number of pages that our buffer use (no of bytes = pages*0x1000)
dword mem=0;                //pointer to our buffer
int cur=0;                  //the place where we are in the buffer
//-------
//Arrays 
//------

string nums[10]={"0","1","2","3","4","5","6","7","8","9"};
string numshex[16]={"0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"};
string eip[1]={"eip"};
string num_identifier[2]={"h","b"};
string level4[2]={"&&","||"};
string level32[2]={">","<"};
string level3[4]={">=","<=","==","!="};
string level2[4]={"+","-","|","#"};
string level1[4]={"*","/","&","%"};
string level0[4]={"~","-"};
//--------------------------
dword Debugger::parser(string s){
    pages=0;
    cur=0;
    mem=(dword)malloc(0x1000);
    memset((char*)mem,0,0x1000);
    pages++;
    s=to_lower_case(s);
    add_to_buffer(process->getsystem()->assembl("push esi"));
    add_to_buffer(process->getsystem()->assembl("push edi"));
    add_to_buffer(process->getsystem()->assembl("push ecx"));
    add_to_buffer(process->getsystem()->assembl("push edx"));
    add_to_buffer(process->getsystem()->assembl("mov esi,ebx"));
    add_to_buffer(process->getsystem()->assembl("mov edi,edx"));
    boolexp(s);
    add_to_buffer(process->getsystem()->assembl("pop edx"));
    add_to_buffer(process->getsystem()->assembl("pop ecx"));
    add_to_buffer(process->getsystem()->assembl("pop edi"));
    add_to_buffer(process->getsystem()->assembl("pop esi"));
    add_to_buffer(process->getsystem()->assembl("ret"));
    return mem;
};
dword Debugger::boolexp(string& s){
    bool con=true;          //continue the loop
      boolexp2(s);
      while (con){
            s=trim(s);
            int n=compare_array(s,level4,2,2);
            if (n !=0){
               s=s.substr(2,s.size());
               switch(n){
                         case 1:doandbool(s);break;
                         case 2:doorbool(s);break;
               };
            }else{
                  con=false;
            };        
      };  
};
dword Debugger::boolexp2(string& s){
      bool con=true;          //continue the loop
      mathexp(s);
      while (con){
            s=trim(s);
            int n=compare_array(s,level3,4,2);
            if (n==0){
                      n=compare_array(s,level32,2,1);
                      if(n>0)n+=4;
            };
            if (n !=0){
               if (n>4){
                  s=s.substr(1,s.size());
               }else{
               s=s.substr(2,s.size());
               };
               switch(n){
                         case 1:dogreaterequal(s);break;
                         case 2:dolowerequal(s);break;
                         case 3:doequal(s);break;
                         case 4:donotequal(s);break;
                         case 5:dogreater(s);break;
                         case 6:dolower(s);break;
               };
            }else{
                  con=false;
            };
            //con=false;       
                 
      };
};
dword Debugger::mathexp(string& s){
      bool con=true;          //continue the loop
      mulexp(s);
      while (con){
            s=trim(s);
            int n=compare_array(s,level2,4,1);
            if (n==3 && compare_array(s,level4,2,2)==2)n=0; 
            if (n !=0){
               s=s.substr(1,s.size());
               switch(n){
                         case 1:doadd(s);break;
                         case 2:dosub(s);break;
                         case 3:door(s);break;
                         case 4:doxor(s);break;
               };
            }else{
                  con=false;
            };
            //con=false;       
                 
      };
};
dword Debugger::mulexp(string& s){
      bool con=true;          //continue the loop
      getnum(s);
      while (con){
            s=trim(s);
            int n=compare_array(s,level1,4,1);
            if (n==3 && compare_array(s,level4,2,2)==1)n=0; 
            if (n !=0){
               s=s.substr(1,s.size());
               switch(n){
                         case 1:domul(s);break;
                         case 2:dodiv(s);break;
                         case 3:doand(s);break;
                         case 4:domod(s);break;
               };
            }else{
                  con=false;
            };         
            //con=false;       
                 
      };
};
dword Debugger::getnum(string& s){
      s=trim(s);
      string s2;
      if (s.substr(0,1)=="("){
         s=s.substr(1,s.size());
         boolexp(s);
         if (s.substr(0,1)==")"){
            s=s.substr(1,s.size());
         }else{
               lasterror=((string)"expect a ')' "); 
               throw(1);
         };
      }else if (compare_array(s,level0,2,1)){                                   //for not & neg
            int n=compare_array(s,level0,2,1);
            s=s.substr(1,s.size());
            switch(n){
                      case 1:donot(s);break;
                      case 2:doneg(s);break;
            };
      }else if (compare_array(s,reg32,8,3)){
            int n=compare_array(s,reg32,8,3)-1;
            s=s.substr(3,s.size());
            doreg32(n);
      }else if (compare_array(s,eip,1,3)){
            s=s.substr(3,s.size());
            doreg32(8);
      }else if (s.substr(0,2)=="__"){          //function
            s=s.substr(2,s.size());
            callfunc(s);
      }else if (s.substr(0,1)=="'"){
            strfunc(s);
      }else if (compare_array(s,nums,10,1)){
             int n=1;
             if (s.substr(0,2)=="0x"){
                s=s.substr(n+1,s.size());
                n=0;
                while(true){
                             if (compare_array(s.substr(n,n+1),numshex,16,1)){
                                n++;
                             }else{break;};  
                 };
                 
                 s2="mov eax,0";
                 s2.append(s.substr(0,n));
                 s2.append("h");
             }else{
                 while(true){
                             if (compare_array(s.substr(n,n+1),nums,10,1)){
                                                             n++;
                             }else if (compare_array(s.substr(n,n+1),num_identifier,2,1)){
                                   n++;
                             }else{break;};  
                 };
                 s2="mov eax,";
                 s2.append(s.substr(0,n));
             };
             add_to_buffer(process->getsystem()->assembl(s2));
             s=s.substr(n,s.size());
      }else{
            lasterror=((string)"expect a number");
            throw(1);  
      };
};

//-------------------------------------------------------------------------------------
//do Math Functions
//-----------------
dword Debugger::domul(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      getnum(s);
      add_to_buffer(process->getsystem()->assembl("mov ecx,eax"));
      add_to_buffer(process->getsystem()->assembl("pop eax"));
      add_to_buffer(process->getsystem()->assembl("mul ecx"));
};
dword Debugger::dodiv(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      getnum(s);
      add_to_buffer(process->getsystem()->assembl("or eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jnz 5h"));
      add_to_buffer(process->getsystem()->assembl("pop edx"));
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("pop edi"));
      add_to_buffer(process->getsystem()->assembl("pop esi"));
      add_to_buffer(process->getsystem()->assembl("ret"));
      add_to_buffer(process->getsystem()->assembl("mov ecx,eax"));
      add_to_buffer(process->getsystem()->assembl("pop eax"));
      add_to_buffer(process->getsystem()->assembl("xor edx,edx"));
      add_to_buffer(process->getsystem()->assembl("div ecx"));
};
dword Debugger::domod(string& s){
      dodiv(s);
      add_to_buffer(process->getsystem()->assembl("mov eax,edx"));
};
dword Debugger::doand(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      getnum(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("and eax,ecx"));
};
//-------
dword Debugger::doadd(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mulexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("add eax,ecx"));
};
dword Debugger::dosub(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mulexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("sub eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("neg eax"));
};
dword Debugger::door(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mulexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("or eax,ecx"));
};
dword Debugger::doxor(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mulexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xor eax,ecx"));
};
dword Debugger::dogreaterequal(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jge 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::dolowerequal(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jle 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::doequal(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jz 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::donotequal(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jnz 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::dogreater(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jg 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::dolower(string& s){
      add_to_buffer(process->getsystem()->assembl("push eax"));
      mathexp(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("xchg eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("cmp eax,ecx"));
      add_to_buffer(process->getsystem()->assembl("jl 4"));
      add_to_buffer(process->getsystem()->assembl("xor eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jmp 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
};
dword Debugger::doandbool(string& s){
      add_to_buffer(process->getsystem()->assembl("or eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jz 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
      add_to_buffer(process->getsystem()->assembl("push eax"));
      boolexp2(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("or eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jz 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
      add_to_buffer(process->getsystem()->assembl("and eax,ecx"));
};
dword Debugger::doorbool(string& s){
      add_to_buffer(process->getsystem()->assembl("or eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jz 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
      add_to_buffer(process->getsystem()->assembl("push eax"));
      boolexp2(s);
      add_to_buffer(process->getsystem()->assembl("pop ecx"));
      add_to_buffer(process->getsystem()->assembl("or eax,eax"));
      add_to_buffer(process->getsystem()->assembl("jz 5"));
      add_to_buffer(process->getsystem()->assembl("mov eax,1"));
      add_to_buffer(process->getsystem()->assembl("or eax,ecx"));
};
dword Debugger::donot(string& s){
      getnum(s);
      add_to_buffer(process->getsystem()->assembl("not eax"));
};
dword Debugger::doneg(string& s){
      getnum(s);
      add_to_buffer(process->getsystem()->assembl("neg eax"));
};



dword Debugger::doreg32(int n){
       Thread* s=new Thread();
       dword n2;
       if (n==8){
          n2=(dword)&s->Eip-(dword)s;
       }else{
             n2=(dword)&s->Exx[n]-(dword)s;
       };
       string s2="mov eax,dword ptr [esi+";
       char s3[3];
       sprintf(s3,"%i",n2);
       //s3[0]=(char)(n2+0x30);
       s3[2]=0;
       s2.append(s3);
       s2.append("]");
       add_to_buffer(process->getsystem()->assembl(s2));
};
//-------------------------------------------------------------------------------------------
dword Debugger::callfunc(string& s){
      int n=s.find_first_of("(");
      int nfunc=0;
      if (n>=s.size()){
         lasterror=((string)"expect '(' for fuction call");
         throw(1);
      };
      n++;               // to add "("
      string s2=s.substr(0,n);
     for (int i=0;i<func_entries;i++){
         if(s2.compare(funcs[i].name)==0) {
                               nfunc=i;
                               goto Func_Found;
                               };
     } 
     lasterror=((string)"unknown function ").append(s2);
     throw(1);
Func_Found:
     s=s.substr(n,s.size());
     for (int i=0;i<funcs[nfunc].params;i++){
           mathexp(s);
           add_to_buffer(process->getsystem()->assembl("push eax"));
           if (s.substr(0,1)!="," && s.substr(0,1)!=")"){
              lasterror=((string)"missing parameter(s) for function ").append(s2);
              throw(1);
           }else{
              s=s.substr(1,s.size());
           };
     };
     if (funcs[nfunc].params==0)s=s.substr(1,s.size());    //for ")"
     add_to_buffer(process->getsystem()->assembl("push edi"));
     add_to_buffer(process->getsystem()->assembl("push esi"));
     string s3="mov eax,";
     char s4[9];
     sprintf(s4,"%x",funcs[nfunc].dbg_func);
     s4[9]=0;
     s3.append(s4);
     s3.append("h");
     add_to_buffer(process->getsystem()->assembl(s3));
     add_to_buffer(process->getsystem()->assembl("call eax"));
     s3="add esp,0";
     char s5[3];
     sprintf(s5,"%x",(funcs[nfunc].params+2)*4);
     s5[3]=0;
     s3.append(s5);
     s3.append("h");
     add_to_buffer(process->getsystem()->assembl(s3));
};
//-------------------------------------------------------------------------------------------
dword Debugger::strfunc(string& s){
      s=s.substr(1,s.size());
      int n=s.find_first_of("'",0);
      if (n > s.size()){ 
            lasterror="unclosed string ";
            lasterror.append(s);
            throw(1);
      };
      string s2=s.substr(0,n);
      dword ptr =(dword)malloc(s2.size()+1);
      memset((dword*)ptr,0,s2.size()+1);
      memcpy((dword*)ptr,s2.c_str(),s2.size());
      s=s.substr(n+1,s.size());
      string s3="mov eax,0";
      char s5[8];
      sprintf(s5,"%x",ptr);
      s5[8]=0;
      s3.append(s5);
      s3.append("h");
      add_to_buffer(process->getsystem()->assembl(s3));
};

void Debugger::add_to_buffer(bytes* ins){
      for (int i=0;i<ins->length;i++){
          ((char*)mem)[cur]=ins->s[i];
          cur++;
      };
};
//-------------------------------------------------------------------------------------------
int Debugger::define_func(string name,int params,dword func,int flags){
  funcs[func_entries].name=name.append("(");
  funcs[func_entries].params=params;
  funcs[func_entries].dbg_func=func;
  funcs[func_entries].flags=flags;
  func_entries++;
};
bool readfunc(Thread* thread,ins_disasm* ins,dword ptr){
     try{
         dword* ptr2 =(dword*)thread->mem->read_virtual_mem((dword)ptr);
         return *ptr2;
     }catch (...){
           return 0;
     }
};
bool isapi(Thread* thread,ins_disasm* ins){
     if (ins->flags & API_CALL)return true;
     return false;
};
bool isapiequal(Thread* thread,ins_disasm* ins,char* s){
     if (ins->flags & API_CALL){
         char* s2=(char*)to_lower_case(thread->process->getsystem()->GetTiggeredAPI(*thread)).c_str();
         if (!strcmp(s,s2))return true;           
     };
     return false;
};
bool lastaccessed(Thread* thread,dword ins){
    //return thread->mem->get_memory_flags(ptr);
    return thread->mem->get_last_accessed();
};
dword lastmodified(Thread* thread,dword ins){
        return thread->mem->get_last_modified();                                 
};
dword dispfunc(Thread* thread,ins_disasm* ins){
      for (int i=0;i<ins->modrm.length;i++){
          if (ins->modrm.flags[i] & RM_DISP)return ins->modrm.items[i];
      }; 
      return 0;
};
dword immfunc(Thread* thread,ins_disasm* ins){
      if (ins->flags & DEST_IMM)return ins->ndest;
      if (ins->flags & SRC_IMM)return ins->nsrc;
      return 0;
};
int isdirty(Thread* thread,dword ins,int ptr){
    return thread->mem->get_memory_flags(ptr);
};
int Debugger::init_funcs(){
    define_func("isdirty",1,(dword)&isdirty,0);
    define_func("lastmodified",0,(dword)&lastmodified,0);
    define_func("lastwritten",0,(dword)&lastmodified,0);
    define_func("lastaccessed",0,(dword)&lastaccessed,0);
    define_func("isapi",0,(dword)&isapi,0);
    define_func("rm",0,(dword)&modrm_calc,0);
    define_func("disp",0,(dword)&dispfunc,0);
    define_func("imm",0,(dword)&immfunc,0);
    define_func("read",1,(dword)&readfunc,0);
    define_func("isapiequal",1,(dword)&isapiequal,0);
};
